/*
 * Decompiled with CFR 0.152.
 */
package com.hoshino.cti.Modifier.aetherCompact;

import com.aetherteam.aether.entity.AetherEntityTypes;
import com.aetherteam.aether.item.AetherItems;
import com.hoshino.cti.Cti;
import com.hoshino.cti.library.modifier.CtiModifierHook;
import com.hoshino.cti.library.modifier.hooks.SlotStackModifierHook;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.ServerStatsCounter;
import net.minecraft.stats.Stats;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import org.jetbrains.annotations.Nullable;
import slimeknights.mantle.client.TooltipKey;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierHooks;
import slimeknights.tconstruct.library.modifiers.hook.armor.ModifyDamageModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.behavior.ToolDamageModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.build.ToolStatsModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.combat.MeleeDamageModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.display.TooltipModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.ranged.ProjectileLaunchModifierHook;
import slimeknights.tconstruct.library.module.ModuleHook;
import slimeknights.tconstruct.library.module.ModuleHookMap;
import slimeknights.tconstruct.library.tools.context.EquipmentContext;
import slimeknights.tconstruct.library.tools.context.ToolAttackContext;
import slimeknights.tconstruct.library.tools.nbt.IModDataView;
import slimeknights.tconstruct.library.tools.nbt.IToolContext;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.nbt.NamespacedNBT;
import slimeknights.tconstruct.library.tools.nbt.ToolStack;
import slimeknights.tconstruct.library.tools.stat.ModifierStatsBuilder;
import slimeknights.tconstruct.library.tools.stat.ToolStats;

public class AmbrosiumPowered
extends Modifier
implements SlotStackModifierHook,
ToolStatsModifierHook,
TooltipModifierHook,
ToolDamageModifierHook,
ProjectileLaunchModifierHook,
MeleeDamageModifierHook,
ModifyDamageModifierHook {
    public static final ResourceLocation KEY_AMBROSIUM_POWER = Cti.getResource("ambrosium_power");

    protected void registerHooks(ModuleHookMap.Builder hookBuilder) {
        super.registerHooks(hookBuilder);
        hookBuilder.addHook((Object)this, new ModuleHook[]{ModifierHooks.TOOL_STATS, CtiModifierHook.SLOT_STACK, ModifierHooks.TOOLTIP, ModifierHooks.TOOL_DAMAGE, ModifierHooks.MELEE_DAMAGE, ModifierHooks.PROJECTILE_LAUNCH, ModifierHooks.MODIFY_HURT});
    }

    @Override
    public boolean overrideOtherStackedOnMe(IToolStackView slotTool, ModifierEntry modifier, ItemStack held, Slot slot, Player player, SlotAccess access) {
        if (held.m_150930_((Item)AetherItems.AMBROSIUM_SHARD.get()) && slot.m_150651_(player)) {
            if (!player.f_19853_.f_46443_ && slotTool.getPersistentData().getInt(KEY_AMBROSIUM_POWER) < 24 * modifier.getLevel()) {
                held.m_41774_(1);
                AmbrosiumPowered.chargeTool(slotTool);
            }
            return true;
        }
        return false;
    }

    public static void chargeTool(IToolStackView toolStackView) {
        toolStackView.getPersistentData().putInt(KEY_AMBROSIUM_POWER, toolStackView.getPersistentData().getInt(KEY_AMBROSIUM_POWER) + 4);
        ((ToolStack)toolStackView).rebuildStats();
    }

    public void addToolStats(IToolContext iToolContext, ModifierEntry modifierEntry, ModifierStatsBuilder modifierStatsBuilder) {
        IModDataView nbt = iToolContext.getPersistentData();
        if (nbt.getInt(KEY_AMBROSIUM_POWER) > 0) {
            List.of(ToolStats.ATTACK_DAMAGE, ToolStats.PROJECTILE_DAMAGE, ToolStats.ATTACK_SPEED, ToolStats.DRAW_SPEED, ToolStats.ARMOR, ToolStats.ARMOR_TOUGHNESS).forEach(stat -> stat.percent(modifierStatsBuilder, 0.5 * (double)modifierEntry.getLevel()));
        }
    }

    public void addTooltip(IToolStackView iToolStackView, ModifierEntry modifierEntry, @Nullable Player player, List<Component> list, TooltipKey tooltipKey, TooltipFlag tooltipFlag) {
        list.add((Component)Component.m_237113_((String)"\u795e\u80fd\u6676\u5145\u80fd\uff1a").m_130946_(String.valueOf(iToolStackView.getPersistentData().getInt(KEY_AMBROSIUM_POWER))).m_130948_(this.getDisplayName().m_7383_()));
    }

    public int onDamageTool(IToolStackView iToolStackView, ModifierEntry modifierEntry, int i, @Nullable LivingEntity livingEntity) {
        if (iToolStackView.getPersistentData().getInt(KEY_AMBROSIUM_POWER) > 0) {
            iToolStackView.getPersistentData().putInt(KEY_AMBROSIUM_POWER, iToolStackView.getPersistentData().getInt(KEY_AMBROSIUM_POWER) - 1);
            return 0;
        }
        return i;
    }

    public static int getBonus(ServerPlayer player) {
        ServerStatsCounter stats = player.m_8951_();
        int bonus = 0;
        if (stats.m_13015_(Stats.f_12986_.m_12902_((Object)((EntityType)AetherEntityTypes.VALKYRIE_QUEEN.get()))) > 0) {
            bonus += 2;
        }
        if (stats.m_13015_(Stats.f_12986_.m_12902_((Object)((EntityType)AetherEntityTypes.SUN_SPIRIT.get()))) > 0) {
            ++bonus;
        }
        return bonus;
    }

    public float getMeleeDamage(IToolStackView tool, ModifierEntry modifier, ToolAttackContext context, float baseDamage, float damage) {
        Player player = context.getPlayerAttacker();
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            return damage + (float)(100 * AmbrosiumPowered.getBonus(serverPlayer));
        }
        return damage;
    }

    public void onProjectileLaunch(IToolStackView tool, ModifierEntry modifier, LivingEntity shooter, Projectile projectile, @Nullable AbstractArrow arrow, NamespacedNBT persistentData, boolean primary) {
        if (shooter instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)shooter;
            if (arrow != null) {
                arrow.m_36781_(arrow.m_36789_() + (double)(100 * AmbrosiumPowered.getBonus(serverPlayer)));
            }
        }
    }

    public float modifyDamageTaken(IToolStackView tool, ModifierEntry modifier, EquipmentContext context, EquipmentSlot slotType, DamageSource source, float amount, boolean isDirectDamage) {
        LivingEntity livingEntity = context.getEntity();
        if (livingEntity instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)livingEntity;
            return amount - (float)AmbrosiumPowered.getBonus(serverPlayer) * 0.15f * amount;
        }
        return amount;
    }
}

